package app.firezone.synk.network.Activities;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.widget.Toast;

import com.google.firebase.database.FirebaseDatabase;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Adapter.NotificationAdapter;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityNotificationBinding;
import app.firezone.synk.network.model.NotificationModel;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;

public class NotificationActivity extends AppCompatActivity {

    ActivityNotificationBinding binding;

    ArrayList<NotificationModel> mlist =  new ArrayList<>();

    NotificationAdapter adapter;

    FirebaseDatabase database;

    Dialog dialog;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityNotificationBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        binding.backArrow.setOnClickListener(v -> finish());

        database = FirebaseDatabase.getInstance();

        LinearLayoutManager layoutManager =  new LinearLayoutManager(NotificationActivity.this);
        binding.notifyRecyer.setLayoutManager(layoutManager);
        layoutManager.setReverseLayout(true);
        layoutManager.setStackFromEnd(true);





        dialog = new Dialog(NotificationActivity.this);
        dialog.setContentView(R.layout.loading_dialog);

        if (dialog.getWindow() !=null){

            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(true);
        }

        dialog.show();



        MyApi myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        Call<ArrayList<NotificationModel>> call = myApi.fetchNotification();

        call.enqueue(new Callback<ArrayList<NotificationModel>>() {
            @Override
            public void onResponse(Call<ArrayList<NotificationModel>> call, Response<ArrayList<NotificationModel>> response) {
                if (response.isSuccessful() && response.body() != null) {
                    dialog.dismiss();
                    mlist.clear(); // Clear old data to avoid duplicates
                    mlist.addAll(response.body());

                    adapter = new NotificationAdapter(NotificationActivity.this, mlist);
                    binding.notifyRecyer.setAdapter(adapter);
                    adapter.notifyDataSetChanged();
                } else {
                    Toast.makeText(NotificationActivity.this, "Failed to fetch notifications", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<NotificationModel>> call, Throwable throwable) {
                dialog.dismiss();
                Toast.makeText(NotificationActivity.this, "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });



    }
}